USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_GenerateDailyBudget]    Script Date: 10/30/2013 12:48:22 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-29>
-- Description:	<This will calculate the amount of points that can be distributed out to the Users for the day it is run.>
-- =============================================
ALTER PROCEDURE [dbo].[RP_GenerateDailyBudget]
AS
DECLARE @monthlyBudgetID int, @addonPercent decimal(3,2), @libraryPercent decimal(3,2), @bonusPercent decimal(3,2),
		@dailyPermiunBudget money, @dailyPoints money, @fairness decimal(3,2), @libraryThreshold int, @popularityThreshold int, @begingOfMonth date,
		@daysLeftInMonth int, @monthlyPointBudget money, @ecpmBudget money, @pointExchangeRate money, @pointsUsedThisMonth money, @pointsRemainingForMonth money
		,@error varchar(2048), @todaysDate date, @testDailyBudgetID int, @codeReturned int
BEGIN
	-- SET XACT_ABORT ON will cause the transaction to be uncommittable when the constraint violation occurs. 
	SET XACT_ABORT ON;
	SET NOCOUNT ON;

	-- see if this has been done today already
	SELECT @todaysDate = GETUTCDATE();
	--SELECT @testDailyBudgetID = (SELECT DailyBudgetDate FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @todaysDate) ;
	IF (SELECT DailyBudgetDate FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @todaysDate) IS NOT NULL 
		 RETURN;

	-- check if monthly budget exist if not run the monthbudget sproc
	SELECT @begingOfMonth = CONVERT(date, DATEADD(dd, -(DAY(GETUTCDATE()) -1), GETUTCDATE()), 101);
	IF (SELECT MonthlyBudgetDate FROM [dbo].[RewardMonthlyBudget] WHERE MonthlyBudgetDate = @begingOfMonth) IS NULL
		BEGIN
			EXEC @codeReturned = [dbo].RP_GenerateMonthlyBudget;
			IF (@codeReturned <> 1)
				RETURN(@codeReturned);
		END;

	-- get fairness, library threshold, popularity threshold, and percentages, monthly budgetID
	SELECT @addonPercent = (SELECT AddonPercentage FROM [dbo].[RewardsProgram]);
	SELECT @libraryPercent = (SELECT LibraryPercentage FROM [dbo].[RewardsProgram]);
	SELECT @bonusPercent = 1.0 - @addonPercent - @libraryPercent;
	SELECT @fairness = (SELECT Fairness FROM [dbo].[RewardsProgram]);
	SELECT @libraryThreshold = (SELECT LibraryThreshold FROM [dbo].[RewardsProgram]);
	SELECT @popularityThreshold = (SELECT PopularityThreshold FROM [dbo].[RewardsProgram]);
	SELECT @monthlyBudgetID = (SELECT ID FROM [dbo].[RewardMonthlyBudget] WHERE MonthlyBudgetDate = @begingOfMonth);

	-- DETERMINE NUMBER OF POINTS FOR TODAYS BUDGET BY:
	-- get Premium or Estimated Budget for the month times by point exchange Rate
	SELECT @pointExchangeRate = (SELECT PointExchangeRate FROM [dbo].[RewardMonthlyBudget] WHERE ID = @monthlyBudgetID);
	SELECT @monthlyPointBudget = (SELECT PremiumBudget FROM [dbo].[RewardMonthlyBudget] WHERE ID = @monthlyBudgetID);
	IF @monthlyPointBudget IS NULL
		SELECT @monthlyPointBudget = (SELECT EstimatedPremiumBudget FROM [dbo].[RewardMonthlyBudget] WHERE ID = @monthlyBudgetID);

	SELECT @ecpmBudget = (SELECT EcpmBudget FROM [dbo].[RewardMonthlyBudget] WHERE ID = @monthlyBudgetID);
	SELECT @monthlyPointBudget = (@monthlyPointBudget + @ecpmBudget) * @pointExchangeRate;

	-- get number of points remaining by, getting amount of points already given out (sum DailyBudget where ID is this months id) then subtract that form total monthly
	SELECT @pointsUsedThisMonth = (SELECT SUM(DailyPoints) FROM [dbo].[RewardDailyBudget] WHERE MonthlyBudgetID = @monthlyBudgetID);
	IF @pointsUsedThisMonth IS NULL
		SELECT @pointsRemainingForMonth = @monthlyPointBudget;
	ELSE
		SELECT @pointsRemainingForMonth = @monthlyPointBudget - @pointsUsedThisMonth;

	-- get daily point budget by, divide number of points remaining by numbers of day in month left
	SELECT @daysLeftInMonth = DATEDIFF(day, GETUTCDATE(), DATEADD(month, 1, DATEADD(day, 1-day(GETUTCDATE()), GETUTCDATE())));
	SELECT @dailyPoints = @pointsRemainingForMonth/@daysLeftInMonth;
	SELECT @dailyPermiunBudget = @dailyPoints/@pointExchangeRate;

BEGIN TRY
	BEGIN TRANSACTION DailyBudget WITH MARK;  --- put all update inserts between the TRANSACTION Begin and COMMIT with XACT_ABORT ON so If one fails they all do not commit
		INSERT INTO [dbo].[RewardDailyBudget]
		(DailyBudgetDate
		,MonthlyBudgetID
		,DateCreated
		,DateModified
		,AddonPercentage
		,LibraryPercentage
		,BonusPercentage
		,DailyPermiumBudget
		,DailyPoints
		,Fairness
		,LibraryThreshold
		,PopularityThreshold)
		VALUES
		(GETUTCDATE()
		,@monthlyBudgetID
		,GETUTCDATE()
		,GETUTCDATE()
		,@addonPercent
		,@libraryPercent
		,@bonusPercent
		,ROUND(@dailyPermiunBudget, 2,1)
		,@dailyPoints
		,@fairness
		,@libraryThreshold
		,@popularityThreshold)
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	ROLLBACK TRANSACTION;
	SELECT @error = ERROR_MESSAGE();
	RETURN(910);
END CATCH;
	RETURN(1);
END



GO


